/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.crafting.lib.reactivex.rxjava3.disposables;

import dev.compactmods.crafting.lib.reactivestreams.Subscription;
import dev.compactmods.crafting.lib.reactivex.rxjava3.annotations.NonNull;
import dev.compactmods.crafting.lib.reactivex.rxjava3.disposables.ActionDisposable;
import dev.compactmods.crafting.lib.reactivex.rxjava3.disposables.AutoCloseableDisposable;
import dev.compactmods.crafting.lib.reactivex.rxjava3.disposables.FutureDisposable;
import dev.compactmods.crafting.lib.reactivex.rxjava3.disposables.RunnableDisposable;
import dev.compactmods.crafting.lib.reactivex.rxjava3.disposables.SubscriptionDisposable;
import dev.compactmods.crafting.lib.reactivex.rxjava3.functions.Action;
import dev.compactmods.crafting.lib.reactivex.rxjava3.internal.disposables.EmptyDisposable;
import dev.compactmods.crafting.lib.reactivex.rxjava3.internal.functions.Functions;
import java.util.Objects;
import java.util.concurrent.Future;

public interface Disposable {
    public void dispose();

    public boolean isDisposed();

    @NonNull
    public static Disposable fromRunnable(@NonNull Runnable run) {
        Objects.requireNonNull(run, "run is null");
        return new RunnableDisposable(run);
    }

    @NonNull
    public static Disposable fromAction(@NonNull Action action) {
        Objects.requireNonNull(action, "action is null");
        return new ActionDisposable(action);
    }

    @NonNull
    public static Disposable fromFuture(@NonNull Future<?> future) {
        Objects.requireNonNull(future, "future is null");
        return Disposable.fromFuture(future, true);
    }

    @NonNull
    public static Disposable fromFuture(@NonNull Future<?> future, boolean allowInterrupt) {
        Objects.requireNonNull(future, "future is null");
        return new FutureDisposable(future, allowInterrupt);
    }

    @NonNull
    public static Disposable fromSubscription(@NonNull Subscription subscription) {
        Objects.requireNonNull(subscription, "subscription is null");
        return new SubscriptionDisposable(subscription);
    }

    @NonNull
    public static Disposable fromAutoCloseable(@NonNull AutoCloseable autoCloseable) {
        Objects.requireNonNull(autoCloseable, "autoCloseable is null");
        return new AutoCloseableDisposable(autoCloseable);
    }

    @NonNull
    public static AutoCloseable toAutoCloseable(@NonNull Disposable disposable) {
        Objects.requireNonNull(disposable, "disposable is null");
        return disposable::dispose;
    }

    @NonNull
    public static Disposable empty() {
        return Disposable.fromRunnable(Functions.EMPTY_RUNNABLE);
    }

    @NonNull
    public static Disposable disposed() {
        return EmptyDisposable.INSTANCE;
    }
}

